package nemosofts.voxradio.activity;

import static android.Manifest.permission.READ_EXTERNAL_STORAGE;
import static android.Manifest.permission.READ_MEDIA_AUDIO;
import static android.Manifest.permission.WRITE_EXTERNAL_STORAGE;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.PopupMenu;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.view.GravityCompat;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.nemosofts.AppCompat;
import androidx.nemosofts.AppCompatActivity;
import androidx.nemosofts.theme.ColorUtils;
import androidx.nemosofts.theme.ThemeEngine;
import androidx.nemosofts.view.BlurImage;
import androidx.nemosofts.view.PlayPauseView;
import androidx.nemosofts.view.RoundedImageView;
import androidx.nemosofts.view.ToggleView;
import androidx.palette.graphics.Palette;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.navigation.NavigationView;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.google.android.material.textview.MaterialTextView;
import com.jetradarmobile.snowfall.SnowfallView;
import com.sothree.slidinguppanel.SlidingUpPanelLayout;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;

import nemosofts.voxradio.BuildConfig;
import nemosofts.voxradio.R;
import nemosofts.voxradio.asyncTask.LoadStatus;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.dialog.FeedBackDialog;
import nemosofts.voxradio.dialog.ReviewDialog;
import nemosofts.voxradio.dialog.TimerCancelDialog;
import nemosofts.voxradio.dialog.TimerStartDialog;
import nemosofts.voxradio.interfaces.SuccessListener;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AudioRecorder;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.IfSupported;
import nemosofts.voxradio.utils.LoadColor;
import nemosofts.voxradio.utils.MessageEvent;
import nemosofts.voxradio.utils.SharedPref;
import nemosofts.voxradio.utils.helper.DBHelper;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.receiver.TimeReceiver;

public class NSoftsPlayerActivity extends AppCompatActivity implements View.OnClickListener {

    ThemeEngine themeEngine;
    Helper helper;
    DBHelper dbHelper;
    SharedPref sharedPref;
    Toolbar toolbar;
    DrawerLayout drawer;
    NavigationView navigationView;

    AudioManager am;
    Boolean isExpand = false;
    SlidingUpPanelLayout mLayout;

    // MINI PLAYER
    RelativeLayout min_header;
    LinearLayout ll_bottom_nav;
    ToggleView tv_nav_home, tv_nav_latest, tv_nav_most, tv_nav_category, tv_nav_restore;
    LinearLayout ll_adView_player;
    ImageView iv_min_previous, iv_min_play, iv_min_next;
    ProgressBar pb_min;
    CircularProgressIndicator circular_min;
    ProgressBar progressBar_min;
    MaterialTextView tv_min_title;
    Handler seekHandler = new Handler();

    // MAIN PLAYER
    public ViewPager viewpager;
    ImagePagerAdapter adapter;
    ImageView volumeDown, volumeUp;
    RelativeLayout rl_music_loading;
    PlayPauseView iv_music_play;
    SeekBar seekBar_music;
    TextView tv_current_time, tv_total_time;
    ImageView iv_music_previous, iv_music_next, iv_radio_timer, iv_microphone;
    TextView tv_music_title, tv_music_artist, tv_song_count;
    RatingBar ratingBar;
    TextView tv_timer;
    AudioManager audioManager;
    SeekBar volumeSeekBar;
    Boolean isExpandVolume = true;
    // Option
    ImageView iv_equalizer, iv_rate, iv_fav, iv_share, iv_bug, iv_option;
    View music_player_options, media_seekbar;

    @SuppressLint("SetTextI18n")
    @Override
    public void onCreate(Bundle savedInstanceState) {
        sharedPref = new SharedPref(this);
        sharedPref.getThemeDetails();
        super.onCreate(savedInstanceState);
        IfSupported.IsRTL(this);
        IfSupported.IsScreenshot(this);

        Callback.context = this;
        am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);

        helper = new Helper(this);
        dbHelper = new DBHelper(this);
        themeEngine = new ThemeEngine(this);

        toolbar = findViewById(R.id.toolbar_offline_music);
        setSupportActionBar(toolbar);
        drawer = findViewById(R.id.drawer_layout);
        navigationView = findViewById(R.id.nav_view);
        ActionBarDrawerToggle toggle = new ActionBarDrawerToggle(
                this, drawer, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        toggle.setDrawerIndicatorEnabled(false);
        toggle.setHomeAsUpIndicator(R.drawable.ic_menu_white);
        toggle.setToolbarNavigationClickListener(view -> drawer.openDrawer(GravityCompat.START));
        drawer.addDrawerListener(toggle);
        toggle.syncState();
        if(Boolean.TRUE.equals(themeEngine.getIsThemeMode())) {
            Objects.requireNonNull(toolbar.getNavigationIcon()).setColorFilter(ContextCompat.getColor(NSoftsPlayerActivity.this, R.color.white), PorterDuff.Mode.SRC_ATOP);
        } else {
            Objects.requireNonNull(toolbar.getNavigationIcon()).setColorFilter(ContextCompat.getColor(NSoftsPlayerActivity.this, R.color.black), PorterDuff.Mode.SRC_ATOP);
        }

        //  MINI PLAYER
        ll_bottom_nav = findViewById(R.id.ll_bottom_nav);
        ll_adView_player = findViewById(R.id.ll_adView_player);
        ll_adView_player.setVisibility(View.GONE);

        tv_nav_home = findViewById(R.id.tv_nav_home);
        tv_nav_home.setBadgeText("");
        tv_nav_latest = findViewById(R.id.tv_nav_latest);
        tv_nav_most = findViewById(R.id.tv_nav_most);
        tv_nav_category = findViewById(R.id.tv_nav_category);
        tv_nav_restore = findViewById(R.id.tv_nav_restore);

        mLayout = findViewById(R.id.sliding_layout);
        min_header = findViewById(R.id.rl_min_header);
        min_header.setOnClickListener(v -> {
        });
        findViewById(R.id.iv_open_player).setOnClickListener(v -> {
            if (mLayout.getPanelState() == SlidingUpPanelLayout.PanelState.COLLAPSED) {
                mLayout.setPanelState(SlidingUpPanelLayout.PanelState.EXPANDED);
            }
        });
        findViewById(R.id.iv_open_player_2).setOnClickListener(v -> {
            if (mLayout.getPanelState() == SlidingUpPanelLayout.PanelState.COLLAPSED) {
                mLayout.setPanelState(SlidingUpPanelLayout.PanelState.EXPANDED);
            }
        });

        progressBar_min = findViewById(R.id.progressBar_min);
        circular_min = findViewById(R.id.circular_min);
        tv_min_title = findViewById(R.id.tv_min_title);
        pb_min = findViewById(R.id.pb_min);
        iv_min_previous = findViewById(R.id.iv_min_previous);
        iv_min_play = findViewById(R.id.iv_min_play);
        iv_min_next = findViewById(R.id.iv_min_next);
        iv_radio_timer = findViewById(R.id.iv_radio_timer);
        iv_microphone = findViewById(R.id.iv_radio_microphone);

        iv_min_play.setOnClickListener(this);
        iv_min_next.setOnClickListener(this);
        iv_min_previous.setOnClickListener(this);
        iv_radio_timer.setOnClickListener(this);
        iv_microphone.setOnClickListener(this);

        // MAIN PLAYER
        audioManager = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
        findViewById(R.id.rl_c).setOnClickListener(v -> {
        });

        volumeDown = findViewById(R.id.volumeDown);
        volumeUp = findViewById(R.id.volumeUp);
        tv_timer = findViewById(R.id.textView_timer);
        rl_music_loading = findViewById(R.id.rl_music_loading);
        iv_music_play = findViewById(R.id.iv_music_play);
        seekBar_music = findViewById(R.id.seekbar_music);
        tv_current_time = findViewById(R.id.tv_music_time);
        tv_total_time = findViewById(R.id.tv_music_total_time);
        iv_music_previous = findViewById(R.id.iv_music_previous);
        iv_music_next = findViewById(R.id.iv_music_next);
        ratingBar = findViewById(R.id.rb_music);
        tv_music_title = findViewById(R.id.tv_music_title);
        tv_music_artist = findViewById(R.id.tv_music_artist);
        tv_song_count = findViewById(R.id.tv_music_song_count);
        volumeSeekBar = findViewById(R.id.volumeSeekBar);

        tv_current_time.setText("00:00");
        tv_total_time.setText("00:00");

        iv_equalizer = findViewById(R.id.iv_player_equalizer);
        iv_rate = findViewById(R.id.iv_player_rate);
        iv_fav = findViewById(R.id.iv_player_fav);
        iv_share = findViewById(R.id.iv_player_share);
        iv_bug = findViewById(R.id.iv_player_bug);
        iv_option = findViewById(R.id.iv_player_option);

        music_player_options = findViewById(R.id.music_player_options);
        media_seekbar = findViewById(R.id.media_seekbar);

        iv_music_play.setOnClickListener(this);
        iv_music_previous.setOnClickListener(this);
        iv_music_next.setOnClickListener(this);
        iv_equalizer.setOnClickListener(this);
        iv_rate.setOnClickListener(this);
        iv_fav.setOnClickListener(this);
        iv_share.setOnClickListener(this);
        iv_bug.setOnClickListener(this);
        iv_option.setOnClickListener(this);

        adapter = new ImagePagerAdapter();

        viewpager = findViewById(R.id.viewPager_song);
        viewpager.setOffscreenPageLimit(5);

        volumeSeekBar.setMax(audioManager.getStreamMaxVolume(AudioManager.STREAM_MUSIC));
        int volume_level = am.getStreamVolume(AudioManager.STREAM_MUSIC);
        volumeSeekBar.setProgress(volume_level);
        volumeSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                if (Boolean.TRUE.equals(isExpandVolume)){
                    audioManager.setStreamVolume(AudioManager.STREAM_MUSIC, i, 0);
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });

        volumeSeekBar.setVisibility(Boolean.TRUE.equals(sharedPref.isVolume()) ? View.VISIBLE : View.GONE);
        volumeDown.setVisibility(Boolean.TRUE.equals(sharedPref.isVolume()) ? View.VISIBLE : View.GONE);
        volumeUp.setVisibility(Boolean.TRUE.equals(sharedPref.isVolume()) ? View.VISIBLE : View.GONE);

        mLayout.addPanelSlideListener(new SlidingUpPanelLayout.PanelSlideListener() {
            @Override
            public void onPanelSlide(View panel, float slideOffset) {
                if (slideOffset == 0.0f) {
                    isExpand = false;
                    min_header.setVisibility(View.VISIBLE);
                } else if (slideOffset > 0.0f && slideOffset < 1.0f) {
                    min_header.setVisibility(View.VISIBLE);
                    min_header.setAlpha(1.0f - slideOffset);
                } else {
                    isExpand = true;
                    min_header.setVisibility(View.INVISIBLE);
                }
            }

            @Override
            public void onPanelStateChanged(View panel, SlidingUpPanelLayout.PanelState previousState, SlidingUpPanelLayout.PanelState newState) {
                if (newState == SlidingUpPanelLayout.PanelState.EXPANDED) {
                    try {
                        if (viewpager.getAdapter() == null || Callback.isNewAdded || !Callback.addedFrom.equals(adapter.getIsLoadedFrom())) {
                            viewpager.setAdapter(adapter);
                        }
                        viewpager.setCurrentItem(Callback.playPos);
                    } catch (Exception e) {
                        adapter.notifyDataSetChanged();
                        viewpager.setCurrentItem(Callback.playPos);
                    }
                    if (Boolean.TRUE.equals(sharedPref.isVolume() && volumeSeekBar.getVisibility() == View.VISIBLE) && volumeSeekBar.getProgress() != audioManager.getStreamVolume(AudioManager.STREAM_MUSIC)){
                        ValueAnimator anim = ValueAnimator.ofInt(volumeSeekBar.getProgress(), audioManager.getStreamVolume(AudioManager.STREAM_MUSIC));
                        anim.setDuration(400);
                        anim.addUpdateListener(animation -> {
                            int animProgress = (Integer) animation.getAnimatedValue();
                            volumeSeekBar.setProgress(animProgress);
                        });
                        anim.addListener(new Animator.AnimatorListener() {
                            @Override
                            public void onAnimationStart(@NonNull Animator animator) {
                                isExpandVolume = false;
                            }

                            @Override
                            public void onAnimationEnd(@NonNull Animator animator) {
                                isExpandVolume = true;
                            }

                            @Override
                            public void onAnimationCancel(@NonNull Animator animator) {
                                isExpandVolume = true;
                            }

                            @Override
                            public void onAnimationRepeat(@NonNull Animator animator) {

                            }
                        });
                        anim.start();
                    }
                }
            }
        });

        viewpager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                changeTextPager(Callback.arrayList_play.get(position));

                View view = viewpager.findViewWithTag("myview" + position);
                if (view != null) {
                    ImageView iv = view.findViewById(R.id.iv_vp_play);
                    if (Callback.playPos == position) {
                        iv.setVisibility(View.GONE);
                    } else {
                        iv.setVisibility(View.VISIBLE);
                    }
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        seekBar_music.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int progress = seekBar.getProgress();
                try {
                    Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                    intent.setAction(PlayerService.ACTION_SEEKTO);
                    intent.putExtra("seekto", ApplicationUtil.getSeekFromPercentage(progress, PlayerService.getInstance().getDuration()));
                    startService(intent);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });

        SnowfallView snowFall = findViewById(R.id.view_snow_fall);
        if (Boolean.TRUE.equals(themeEngine.getIsThemeMode() || Callback.nowPlayingScreen == 3) || Callback.nowPlayingScreen == 4){
            if (Boolean.TRUE.equals(sharedPref.isSnowFall())){
                snowFall.restartFalling();
            } else {
                snowFall.stopFalling();
            }
            snowFall.setVisibility(Boolean.TRUE.equals(sharedPref.isSnowFall()) ? View.VISIBLE : View.GONE);
        } else {
            snowFall.stopFalling();
            snowFall.setVisibility(View.GONE);
        }

        if (Callback.nowPlayingScreen == 3 || Callback.nowPlayingScreen == 4){
            loadIconColor();
        }

        rl_music_loading.setOnClickListener( v -> {
            if (PlayerService.getInstance() != null && rl_music_loading.getVisibility() == View.VISIBLE) {
                GlobalBus.getBus().postSticky(new MessageEvent(false, "buffer"));
                Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                intent.setAction(PlayerService.ACTION_STOP);
                startService(intent);
                Toast.makeText(NSoftsPlayerActivity.this, "Stop Audio", Toast.LENGTH_SHORT).show();
            }
        });

        if (Boolean.TRUE.equals(sharedPref.getIsSleepTimeOn())) {
            sharedPref.setCheckSleepTime();
            updateTimer(sharedPref.getSleepTime());
        }
        getRecording();
    }
    private void loadIconColor() {
        tv_music_title.setTextColor(ColorUtils.colorWhite(this));
        tv_music_artist.setTextColor(ColorUtils.colorWhite(this));
        tv_song_count.setTextColor(ColorUtils.colorWhite(this));
        tv_current_time.setTextColor(ColorUtils.colorWhite(this));
        tv_total_time.setTextColor(ColorUtils.colorWhite(this));
        seekBar_music.setBackgroundTintList(ColorStateList.valueOf(ColorUtils.colorWhite(this)));

        volumeDown.setColorFilter(ColorUtils.colorWhite(this));
        volumeUp.setColorFilter(ColorUtils.colorWhite(this));

        iv_music_previous.setColorFilter(ColorUtils.colorWhite(this));
        iv_music_next.setColorFilter(ColorUtils.colorWhite(this));

        iv_radio_timer.setColorFilter(ColorUtils.colorWhite(this));

        iv_equalizer.setColorFilter(ColorUtils.colorWhite(this));
        iv_rate.setColorFilter(ColorUtils.colorWhite(this));
        iv_fav.setColorFilter(ColorUtils.colorWhite(this));
        iv_share.setColorFilter(ColorUtils.colorWhite(this));
        iv_bug.setColorFilter(ColorUtils.colorWhite(this));
        iv_option.setColorFilter(ColorUtils.colorWhite(this));

        iv_radio_timer.setColorFilter(ColorUtils.colorWhite(this));
        iv_microphone.setImageResource(R.drawable.ic_microphone2);
    }

    @SuppressLint("SetTextI18n")
    private void changeTextPager(ItemRadio itemRadio) {
        if (itemRadio != null) {
            ratingBar.setRating(Integer.parseInt(itemRadio.getAverageRating()));
            tv_music_artist.setText(itemRadio.getCategoryName());
            tv_music_title.setText(itemRadio.getRadioTitle());
            tv_song_count.setText((viewpager.getCurrentItem() + 1) + "/" + Callback.arrayList_play.size());
        }
    }

    @SuppressLint("SetTextI18n")
    public void changeText(@NonNull ItemRadio itemRadio) {
        //  MINI PLAYER
        String subName, artist_name="";
        if (!itemRadio.getCategoryName().isEmpty()) {
            artist_name = itemRadio.getCategoryName();
        }
        subName = itemRadio.getRadioTitle() +" • "+ artist_name;
        tv_min_title.setText(subName);
        if (!tv_min_title.getText().toString().isEmpty()){
            tv_min_title.setSelected(true);
        }

        // MAIN PLAYER
        ratingBar.setRating(Integer.parseInt(itemRadio.getAverageRating()));
        tv_music_title.setText(itemRadio.getRadioTitle());
        tv_music_artist.setText(itemRadio.getCategoryName());
        tv_song_count.setText(Callback.playPos + 1 + "/" + Callback.arrayList_play.size());
        changeFav(itemRadio.IsFav());

        ratingBar.setVisibility(Boolean.TRUE.equals(Callback.isRadio) ? View.VISIBLE : View.INVISIBLE);
        music_player_options.setVisibility(Boolean.TRUE.equals(Callback.isRadio) ? View.VISIBLE : View.INVISIBLE);

        circular_min.setVisibility(Boolean.TRUE.equals(Callback.isRadio) ? View.INVISIBLE : View.VISIBLE);
        progressBar_min.setVisibility(Boolean.TRUE.equals(Callback.isRadio) ? View.INVISIBLE : View.VISIBLE);
        media_seekbar.setVisibility(Boolean.TRUE.equals(Callback.isRadio) ? View.INVISIBLE : View.VISIBLE);

        if (Callback.nowPlayingScreen == 2){
            LoadColorTitle(itemRadio);
        }

        if (Callback.nowPlayingScreen == 3){
            ImageView bg_player_blur = findViewById(R.id.iv_bg_player_blur);
            bg_player_blur.setImageResource(R.drawable.shadow_up_now_play);
            new LoadColor(bg_player_blur).execute(itemRadio.getImage());
        }

        if (Callback.nowPlayingScreen == 4){
            LoadBgBlur(itemRadio);
        }

        if (viewpager.getAdapter() == null || Callback.isNewAdded || !Callback.addedFrom.equals(adapter.getIsLoadedFrom())) {
            viewpager.setAdapter(adapter);
            Callback.isNewAdded = false;
        }
        try {
            viewpager.setCurrentItem(Callback.playPos);
        } catch (Exception e) {
            adapter.notifyDataSetChanged();
            viewpager.setCurrentItem(Callback.playPos);
        }
    }

    private void LoadBgBlur(ItemRadio itemRadio) {
        final  ImageView bg_player_blur = findViewById(R.id.iv_bg_player_blur);
        try {
            Target target = new Target() {
                @Override
                public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                    try {
                        int blur_amount = sharedPref.getBlurAmount();
                        if (blur_amount >= 0 && blur_amount < 6) {
                            bg_player_blur.setImageBitmap(BlurImage.fastBlur(bitmap, 1f, 5));
                        }else {
                            bg_player_blur.setImageBitmap(BlurImage.fastBlur(bitmap, 1f, blur_amount));
                        }
                        findViewById(R.id.iv_bg_blur).setVisibility(View.VISIBLE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                    bg_player_blur.setImageResource(R.drawable.shadow_up_now_play);
                    findViewById(R.id.iv_bg_blur).setVisibility(View.INVISIBLE);
                }
                @Override
                public void onPrepareLoad(Drawable placeHolderDrawable) {

                }
            };
            bg_player_blur.setTag(target);
            Picasso.get()
                    .load(itemRadio.getImage())
                    .placeholder(R.drawable.material_design_default)
                    .into(target);

        } catch (Exception e) {
            e.printStackTrace();
            bg_player_blur.setImageResource(R.drawable.shadow_up_now_play);
            findViewById(R.id.iv_bg_blur).setVisibility(View.INVISIBLE);
        }
    }

    private void LoadColorTitle(ItemRadio itemRadio) {
        try {
            Picasso.get()
                    .load(itemRadio.getImage())
                    .centerCrop()
                    .resize(100, 100)
                    .into(new Target() {
                        @Override
                        public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                            try {
                                Palette.from(bitmap).generate(palette -> {
                                    if (palette != null) {
                                        Palette.Swatch textSwatch = palette.getVibrantSwatch();
                                        if (textSwatch != null) {
                                            try {
                                                tv_music_title.setBackgroundTintList(ColorStateList.valueOf(textSwatch.getRgb()));
                                                tv_music_artist.setBackgroundTintList(ColorStateList.valueOf(textSwatch.getRgb()));
                                                tv_music_title.setTextColor(ColorUtils.colorWhite(NSoftsPlayerActivity.this));
                                                tv_music_artist.setTextColor(ColorUtils.colorWhite(NSoftsPlayerActivity.this));
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    }
                                });
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        @Override
                        public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                        }
                        @Override
                        public void onPrepareLoad(Drawable placeHolderDrawable) {
                        }
                    });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ImagePagerAdapter extends PagerAdapter {

        private final LayoutInflater inflater;
        private String loadedPage = "";

        private ImagePagerAdapter() {
            inflater = getLayoutInflater();
        }

        @Override
        public int getCount() {
            return Callback.arrayList_play.size();
        }

        @Override
        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view.equals(object);
        }

        String getIsLoadedFrom() {
            return loadedPage;
        }

        @NonNull
        @Override
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            View imageLayout;
            boolean isTextColor;
            switch (Callback.nowPlayingScreen) {
                case 1:
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_circle, container, false);
                    isTextColor = false;
                    break;
                case 2:
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_flat, container, false);
                    isTextColor = true;
                    break;
                case 5:
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_corner, container, false);
                    isTextColor = true;
                    break;
                case 6:
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_corner_bottom, container, false);
                    isTextColor = true;
                    break;
                default:
                    imageLayout = inflater.inflate(R.layout.row_viewpager_player_normal, container, false);
                    isTextColor = true;
                    break;
            }
            assert imageLayout != null;

            RoundedImageView imageView = imageLayout.findViewById(R.id.image);
            final ImageView imageView_play = imageLayout.findViewById(R.id.iv_vp_play);
            final ProgressBar spinner = imageLayout.findViewById(R.id.loading);
            final RelativeLayout rl_text = imageLayout.findViewById(R.id.rl_text);

            loadedPage = Callback.addedFrom;

            if (Callback.playPos == position) {
                imageView_play.setVisibility(View.GONE);
            }

            Picasso.get()
                    .load(Callback.arrayList_play.get(position).getImage())
                    .placeholder(R.drawable.material_design_default)
                    .into(imageView, new com.squareup.picasso.Callback() {
                        @Override
                        public void onSuccess() {
                            spinner.setVisibility(View.GONE);
                        }

                        @Override
                        public void onError(Exception e) {
                            spinner.setVisibility(View.GONE);
                        }
                    });

            if (isTextColor) {
                Picasso.get()
                        .load(Callback.arrayList_play.get(position).getImage())
                        .centerCrop()
                        .resize(100, 100)
                        .into(new Target() {
                            @Override
                            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                                try {
                                    Palette.from(bitmap).generate(palette -> {
                                        if (palette != null) {
                                            Palette.Swatch textSwatch = palette.getVibrantSwatch();
                                            if (textSwatch != null) {
                                                rl_text.setBackgroundTintList(ColorStateList.valueOf(textSwatch.getRgb()));
                                            }
                                        }
                                    });
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                            }

                            @Override
                            public void onPrepareLoad(Drawable placeHolderDrawable) {
                            }
                        });
            }
            imageView_play.setOnClickListener(v -> {
                if (helper.isNetworkAvailable()) {
                    try {
                        Callback.playPos = viewpager.getCurrentItem();
                        Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                        intent.setAction(PlayerService.ACTION_PLAY);
                        startService(intent);
                        imageView_play.setVisibility(View.GONE);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                }
            });

            imageLayout.setTag("myview" + position);
            container.addView(imageLayout, 0);
            return imageLayout;

        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View) object);
        }
    }

    private final Runnable run = this::seekUpdating;

    public void seekUpdating() {
        if (Boolean.FALSE.equals(Callback.isRadio)){
            try {
                circular_min.setProgress(ApplicationUtil.getProgressPercentage(PlayerService.exoPlayer.getCurrentPosition(), PlayerService.getInstance().getDuration()));
                progressBar_min.setProgress(ApplicationUtil.getProgressPercentage(PlayerService.exoPlayer.getCurrentPosition(), PlayerService.getInstance().getDuration()));

                seekBar_music.setProgress(ApplicationUtil.getProgressPercentage(PlayerService.exoPlayer.getCurrentPosition(), PlayerService.getInstance().getDuration()));
                tv_current_time.setText(ApplicationUtil.milliSecondsToTimer(PlayerService.exoPlayer.getCurrentPosition(), PlayerService.getInstance().getDuration()));
                tv_total_time.setText(ApplicationUtil.milliSecondsToTimer(PlayerService.exoPlayer.getDuration(), PlayerService.getInstance().getDuration()));
                seekBar_music.setSecondaryProgress(PlayerService.exoPlayer.getBufferedPercentage());

                if (PlayerService.exoPlayer.getPlayWhenReady() && Boolean.TRUE.equals(Callback.isAppOpen)) {
                    seekHandler.removeCallbacks(run);
                    seekHandler.postDelayed(run, 1000);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(@NonNull View view) {
        switch (view.getId()) {
            case R.id.iv_min_play:
            case R.id.iv_music_play:
                playPause();
                break;
            case R.id.iv_min_next:
            case R.id.iv_music_next:
                next();
                break;
            case R.id.iv_min_previous:
            case R.id.iv_music_previous:
                previous();
                break;
            case R.id.iv_radio_timer:
                if (Boolean.FALSE.equals(sharedPref.getIsSleepTimeOn())) {
                    setStartTimer();
                } else {
                    setCancelTimer();
                }
                break;
            case R.id.iv_radio_microphone:
                recordRadio();
                break;
            case R.id.iv_player_equalizer:
                openEqualizer();
                break;
            case R.id.iv_player_rate:
                showRateDialog();
                break;
            case R.id.iv_player_fav:
                loadFav();
                break;
            case R.id.iv_player_share:
                shareIntent();
                break;
            case R.id.iv_player_bug:
                feedBackDialog();
                break;
            case R.id.iv_player_option:
                openOptionPopUp();
                break;
            default:
                break;
        }
    }

    private void openOptionPopUp() {
        ContextThemeWrapper ctw = new ContextThemeWrapper(NSoftsPlayerActivity.this, Boolean.TRUE.equals(themeEngine.getIsThemeMode()) ? R.style.PopupMenuDark :  R.style.PopupMenuLight);
        PopupMenu popup = new PopupMenu(ctw, iv_option);
        popup.getMenuInflater().inflate(R.menu.popup_player_option, popup.getMenu());
        popup.setForceShowIcon(true);
        popup.setOnMenuItemClickListener(item -> {
            if (item.getItemId() == R.id.popup_description) {
                if (!Callback.arrayList_play.isEmpty()){
                    String radio_id = Callback.arrayList_play.get(viewpager.getCurrentItem()).getId();
                    String radio_title = Callback.arrayList_play.get(viewpager.getCurrentItem()).getRadioTitle();
                    Intent intent = new Intent(NSoftsPlayerActivity.this, WebActivity.class);
                    intent.putExtra("web_url", BuildConfig.BASE_URL+"radio_description.php?radio_id="+radio_id);
                    intent.putExtra("page_title", radio_title);
                    ActivityCompat.startActivity(NSoftsPlayerActivity.this, intent, null);
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
                }
            }
            else if (item.getItemId() == R.id.popup_go_to_category) {
                if (!Callback.arrayList_play.isEmpty()){
                    Intent intent = new Intent(NSoftsPlayerActivity.this, RadioByActivity.class);
                    intent.putExtra("type", getString(R.string.categories));
                    intent.putExtra("id",  Callback.arrayList_play.get(viewpager.getCurrentItem()).getCatID());
                    intent.putExtra("name",  Callback.arrayList_play.get(viewpager.getCurrentItem()).getCategoryName());
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    startActivity(intent);
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
                }
            }
            else if (item.getItemId() == R.id.popup_drive_mode) {
                if (!Callback.arrayList_play.isEmpty()){
                    startActivity(new Intent(NSoftsPlayerActivity.this, DriveModeActivity.class));
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
                }
            }
            return true;
        });
        popup.show();
    }

    private void openEqualizer() {
        if(PlayerService.getInstance() != null && Callback.isPlayed) {
            Intent intent = new Intent(NSoftsPlayerActivity.this, EqualizerActivity.class);
            startActivity(intent);
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, "play a Radio", Toast.LENGTH_SHORT).show();
        }
    }

    private void loadFav() {
        if (!Callback.arrayList_play.isEmpty()){
            if (sharedPref.isLogged()) {
                if (helper.isNetworkAvailable()) {
                    LoadStatus loadFav = new LoadStatus(new SuccessListener() {
                        @Override
                        public void onStart() {
                            changeFav(!Callback.arrayList_play.get(viewpager.getCurrentItem()).IsFav());
                        }

                        @Override
                        public void onEnd(String success, String favSuccess, String message) {
                            if (success.equals("1")) {
                                Callback.arrayList_play.get(viewpager.getCurrentItem()).setIsFav(message.equals("Added to Favourite"));
                                changeFav(Callback.arrayList_play.get(viewpager.getCurrentItem()).IsFav());
                                Toast.makeText(NSoftsPlayerActivity.this, message, Toast.LENGTH_SHORT).show();
                            } else {
                                Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                            }
                        }
                    }, helper.getAPIRequest(Callback.METHOD_DO_FAV, 0, Callback.arrayList_play.get(viewpager.getCurrentItem()).getId(), "", "", "", sharedPref.getUserId(), "", "", "", "", "", "", "", null));
                    loadFav.execute();
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                }
            } else {
                helper.clickLogin();
            }
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    private void showRateDialog() {
        if (!Callback.arrayList_play.isEmpty()) {
            ReviewDialog reviewDialog = new ReviewDialog(this, new ReviewDialog.RatingDialogListener() {
                @Override
                public void onShow() {

                }

                @Override
                public void onGetRating(String rating, String message) {
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).setUserRating(String.valueOf(rating));
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).setUserMessage(message);
                }

                @Override
                public void onDismiss(String success, String rateSuccess, String message, int rating, String userRating, String userMessage) {
                    if (success.equals("1")) {
                        if (rateSuccess.equals("1")) {
                            try {
                                Callback.arrayList_play.get(viewpager.getCurrentItem()).setAverageRating(String.valueOf(rating));
                                Callback.arrayList_play.get(viewpager.getCurrentItem()).setTotalRate(String.valueOf(Integer.parseInt(Callback.arrayList_play.get(viewpager.getCurrentItem()).getTotalRate() + 1)));
                                Callback.arrayList_play.get(viewpager.getCurrentItem()).setUserRating(String.valueOf(userRating));
                                Callback.arrayList_play.get(viewpager.getCurrentItem()).setUserMessage(String.valueOf(userMessage));
                                ratingBar.setRating(rating);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Toast.makeText(NSoftsPlayerActivity.this, message, Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }
            });
            reviewDialog.showDialog(
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).getId(),
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).getUserRating(),
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).getUserMessage()
            );
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_no_data_found), Toast.LENGTH_SHORT).show();
        }
    }

    private void feedBackDialog() {
        if (!Callback.arrayList_play.isEmpty()) {
            new FeedBackDialog(this).showDialog(
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).getId(),
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).getRadioTitle()
            );
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_no_data_found), Toast.LENGTH_SHORT).show();
        }
    }

    private void shareIntent() {
        if (!Callback.arrayList_play.isEmpty()){
            Intent sendIntent = new Intent();
            sendIntent.setAction(Intent.ACTION_SEND);
            sendIntent.putExtra(Intent.EXTRA_TEXT,
                    Callback.arrayList_play.get(viewpager.getCurrentItem()).getRadioTitle()+ "\n\n" +
                            Callback.arrayList_play.get(viewpager.getCurrentItem()).getCategoryName()+ "\n" +
                            "https://play.google.com/store/apps/details?id=" + getPackageName());
            sendIntent.setType("text/plain");
            startActivity(sendIntent);
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    private void recordRadio() {
        if (Boolean.TRUE.equals(checkPer())){
            if (Boolean.FALSE.equals(AudioRecorder.getIsRecord())) {
                if (PlayerService.getInstance() != null && Callback.isPlayed && Boolean.TRUE.equals(Callback.isRadio)) {
                    new AudioRecorder(this).onStartRecord();
                    if (Boolean.TRUE.equals(themeEngine.getIsThemeMode())) {
                        iv_microphone.setImageResource(R.drawable.ic_microphone_b);
                    } else {
                        if (Callback.nowPlayingScreen == 3 || Callback.nowPlayingScreen == 4){
                            iv_microphone.setImageResource(R.drawable.ic_microphone_b);
                        } else {
                            iv_microphone.setImageResource(R.drawable.ic_microphone_b2);
                        }
                    }
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.recording_start), Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.not_start_fm), Toast.LENGTH_SHORT).show();
                }
            } else {
                AudioRecorder.onStopRecord();
                if (Boolean.TRUE.equals(themeEngine.getIsThemeMode())) {
                    iv_microphone.setImageResource(R.drawable.ic_microphone2);
                } else {
                    if (Callback.nowPlayingScreen == 3 || Callback.nowPlayingScreen == 4){
                        iv_microphone.setImageResource(R.drawable.ic_microphone2);
                    } else {
                        iv_microphone.setImageResource(R.drawable.ic_microphone);
                    }
                }
                Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.recording_complete), Toast.LENGTH_SHORT).show();
            }
        }
    }

    @SuppressLint("ScheduleExactAlarm")
    private void setStartTimer() {
        TimerStartDialog timerStart = new TimerStartDialog(this, (hours, minute) -> {
            String totalTime = hours + ":" + minute;
            long total_timer = ApplicationUtil.convert_long(totalTime) + System.currentTimeMillis();

            Random random = new Random();
            int id = random.nextInt(100);

            sharedPref.setSleepTime(true, total_timer, id);

            Intent intent = new Intent(NSoftsPlayerActivity.this, TimeReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(NSoftsPlayerActivity.this, id, intent, PendingIntent.FLAG_IMMUTABLE);
            AlarmManager alarmManager = (AlarmManager) getSystemService(ALARM_SERVICE);
            alarmManager.setExact(AlarmManager.RTC_WAKEUP, total_timer, pendingIntent);
            updateTimer(total_timer);
        });
        timerStart.showDialog();
    }

    private void updateTimer(long total_timer) {
        long time_left = total_timer - System.currentTimeMillis();
        if (time_left > 0) {

            @SuppressLint("DefaultLocale")
            String hms = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(time_left),
                    TimeUnit.MILLISECONDS.toMinutes(time_left) % TimeUnit.HOURS.toMinutes(1),
                    TimeUnit.MILLISECONDS.toSeconds(time_left) % TimeUnit.MINUTES.toSeconds(1));
            tv_timer.setVisibility(View.VISIBLE);
            tv_timer.setText(hms);

            new Handler().postDelayed(() -> {
                if (Boolean.TRUE.equals(sharedPref.getIsSleepTimeOn())) {
                    updateTimer(total_timer);
                } else {
                    tv_timer.setVisibility(View.GONE);
                }
            }, 1000);
        } else {
            tv_timer.setVisibility(View.GONE);
        }
    }

    private void setCancelTimer() {
        TimerCancelDialog timerCancel = new TimerCancelDialog(this, () -> {
            tv_timer.setVisibility(View.GONE);

            Intent intent = new Intent(NSoftsPlayerActivity.this, TimeReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(NSoftsPlayerActivity.this, sharedPref.getSleepID(), intent, PendingIntent.FLAG_IMMUTABLE);
            AlarmManager alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
            pendingIntent.cancel();
            alarmManager.cancel(pendingIntent);
            sharedPref.setSleepTime(false, 0, 0);
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.stop_timer), Toast.LENGTH_SHORT).show();
        });
        timerCancel.showDialog();
    }

    public void playPause() {
        if (!Callback.arrayList_play.isEmpty()) {
            Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
            if (Boolean.TRUE.equals(Callback.isPlayed)) {
                intent.setAction(PlayerService.ACTION_TOGGLE);
                startService(intent);
            } else {
                if (helper.isNetworkAvailable()) {
                    intent.setAction(PlayerService.ACTION_PLAY);
                    startService(intent);
                } else {
                    Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                }
            }
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    public void next() {
        if (!Callback.arrayList_play.isEmpty()) {
            if (helper.isNetworkAvailable()) {
                Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                intent.setAction(PlayerService.ACTION_NEXT);
                startService(intent);
            } else {
                Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            }
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    public void previous() {
        if (!Callback.arrayList_play.isEmpty()) {
            if (helper.isNetworkAvailable()) {
                Intent intent = new Intent(NSoftsPlayerActivity.this, PlayerService.class);
                intent.setAction(PlayerService.ACTION_PREVIOUS);
                startService(intent);
            } else {
                Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            }
        } else {
            Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.error_no_radio_selected), Toast.LENGTH_SHORT).show();
        }
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    public void changeFav(Boolean isFav) {
        if (Boolean.FALSE.equals(isFav)) {
            iv_fav.setImageDrawable(getResources().getDrawable(R.drawable.ic_favorite_border));
        } else {
            iv_fav.setImageDrawable(getResources().getDrawable(R.drawable.ic_favorite_do));
        }
        if (Callback.nowPlayingScreen == 3 || Callback.nowPlayingScreen == 4){
            iv_fav.setColorFilter(ColorUtils.colorWhite(NSoftsPlayerActivity.this));
        } else {
            iv_fav.setColorFilter(ColorUtils.colorTitle(NSoftsPlayerActivity.this));
        }
    }

    @Override
    public int setLayoutResourceId() {
        if (Callback.nowPlayingScreen == 2) {
            return R.layout.activity_base_flat;
        }
        return R.layout.activity_base_normal;
    }

    @Override
    public int setAppCompat() {
        return AppCompat.COMPAT();
    }

    private void getRecording() {
        if (Boolean.TRUE.equals(AudioRecorder.getIsRecord())) {
            if (Boolean.TRUE.equals(themeEngine.getIsThemeMode())) {
                iv_microphone.setImageResource(R.drawable.ic_microphone_b);
            } else {
                if (Callback.nowPlayingScreen == 3 || Callback.nowPlayingScreen == 4){
                    iv_microphone.setImageResource(R.drawable.ic_microphone_b);
                } else {
                    iv_microphone.setImageResource(R.drawable.ic_microphone_b2);
                }
            }
        } else {
            if (Boolean.TRUE.equals(themeEngine.getIsThemeMode())) {
                iv_microphone.setImageResource(R.drawable.ic_microphone2);
            } else {
                if (Callback.nowPlayingScreen == 3 || Callback.nowPlayingScreen == 4){
                    iv_microphone.setImageResource(R.drawable.ic_microphone2);
                } else {
                    iv_microphone.setImageResource(R.drawable.ic_microphone);
                }
            }
        }
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    public void changePlayPauseIcon(Boolean isPlay) {
        if (Boolean.FALSE.equals(isPlay)) {
            iv_min_play.setImageDrawable(getResources().getDrawable(R.drawable.ic_play));
        } else {
            iv_min_play.setImageDrawable(getResources().getDrawable(R.drawable.ic_pause));
        }
        iv_music_play.change(!isPlay);
        seekUpdating();
    }

    public void isBuffering(Boolean isBuffer) {
        if (isBuffer != null){
            if (Boolean.FALSE.equals(isBuffer)) {
                iv_music_play.setVisibility(View.VISIBLE);
                rl_music_loading.setVisibility(View.INVISIBLE);
                pb_min.setVisibility(View.INVISIBLE);
                changePlayPauseIcon(true);
            } else {
                iv_music_play.setVisibility(View.INVISIBLE);
                rl_music_loading.setVisibility(View.VISIBLE);
                pb_min.setVisibility(View.VISIBLE);
            }

            iv_min_next.setEnabled(!isBuffer);
            iv_min_previous.setEnabled(!isBuffer);

            iv_music_next.setEnabled(!isBuffer);
            iv_music_previous.setEnabled(!isBuffer);
            seekBar_music.setEnabled(!isBuffer);
        }
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onSongChange(ItemRadio itemRadio) {
        changeText(itemRadio);
        Callback.context = NSoftsPlayerActivity.this;
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onBufferChange(@NonNull MessageEvent messageEvent) {
        if (messageEvent.message.equals("buffer")) {
            isBuffering(messageEvent.flag);
        } else {
            changePlayPauseIcon(messageEvent.flag);
        }
        getRecording();
    }

    @SuppressLint("SetTextI18n")
    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onViewPagerChanged(ItemPodcasts itemPodcasts) {
        adapter.notifyDataSetChanged();
        tv_song_count.setText(Callback.playPos + 1 + "/" + Callback.arrayList_play.size());
        GlobalBus.getBus().removeStickyEvent(itemPodcasts);
    }

    @Override
    public void onStart() {
        super.onStart();
        GlobalBus.getBus().register(this);
    }

    @Override
    public void onStop() {
        GlobalBus.getBus().unregister(this);
        super.onStop();
    }

    @Override
    protected void onPause() {
        try {
            seekHandler.removeCallbacks(run);
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onPause();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_HEADSETHOOK) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public Boolean checkPer() {
        if (Build.VERSION.SDK_INT >= 33) {
            if ((ContextCompat.checkSelfPermission(NSoftsPlayerActivity.this, READ_MEDIA_AUDIO) != PackageManager.PERMISSION_GRANTED)) {
                requestPermissions(new String[]{READ_MEDIA_AUDIO}, 101);
                return false;
            } else {
                return true;
            }
        } else if (android.os.Build.VERSION.SDK_INT >= 29) {
            if ((ContextCompat.checkSelfPermission(NSoftsPlayerActivity.this, READ_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED)) {
                requestPermissions(new String[]{READ_EXTERNAL_STORAGE}, 101);
                return false;
            } else {
                return true;
            }
        } else {
            if ((ContextCompat.checkSelfPermission(NSoftsPlayerActivity.this, WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) && (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)) {
                requestPermissions(new String[]{WRITE_EXTERNAL_STORAGE}, 101);
                return false;
            }
            return true;
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        boolean canUseExternalStorage = false;
        if (requestCode == 101) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                canUseExternalStorage = true;
            }
            if (!canUseExternalStorage) {
                Toast.makeText(NSoftsPlayerActivity.this, getString(R.string.err_cannot_use_features), Toast.LENGTH_SHORT).show();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }
}
